import numpy as np
import os

def generate_and_save_embeddings(n=1000, dim=768, output_file_prefix="embeddings"):

    embeddings = np.random.randn(n, dim).astype(np.float32)
    
    filename = f"/workspace/0410_nips/2_hashtree/embds/{n}_{dim}_{output_file_prefix}.npy"
    np.save(filename, embeddings)
    print(f"[✓] Saved embeddings: shape=({n}, {dim}) to '{filename}'")

if __name__ == "__main__":
    lengths = [1024, 2048, 4096, 8192, 8192 * 2, 8192 * 4, 8192 * 8]
    dims = [768, 768 * 2, 768 * 4]

    for length in lengths:
        for dim in dims:
            generate_and_save_embeddings(n=length, dim=dim)
